/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <aauto/AditEndpointCommon.h>
#include "NaviStatus.h"

LOG_DECLARE_CONTEXT(navi_status);

using namespace adit::aauto;

namespace adit { namespace aauto {

AditNavigationStatus* NavigationStatusCreate(uint8_t        inSessionId,
                                             MessageRouter* inMessageRouter,
                                             int            inMinIntervalMs,
                                             int            inheight,
                                             int            inWidth,
                                             int            inColorDepthBits,
                                             NavigationStatusService_InstrumentClusterType inType)
{
    if(inMessageRouter == nullptr)
    {
        LOG_ERROR((navi_status, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new NaviStatus(inSessionId,
                          inMessageRouter,
                          inMinIntervalMs,
                          inheight,
                          inWidth,
                          inColorDepthBits,
                          inType);
}

/*
 * In case the library is linked at compile time it is more convenient to call unique functions
 * rather than the generic plug-in versions.
 */

void NavigationStatusEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    // register gstreamer at logging
    LOG_REGISTER_CONTEXT(navi_status, "TANS", "Test aauto navi status");
    LOGD_DEBUG((navi_status, "aauto-test-navigation git tag: %s", COMP_GIT_VERSION));


    if (inFactoryRegisterFn != nullptr)
    {
        // it is not required to use the factory
        inFactoryRegisterFn("NavigationStatus", FactoryNavigationStatus,
                (CreatorFn)NavigationStatusCreate);
    }
    else
    {
        LOG_FATAL((navi_status, "Unable to register navigation-status test adapters"));
    }
}

void NavigationStatusExitPoint()
{
    LOG_UNREGISTER_CONTEXT(navi_status);
}

} } // namespace adit { namespace aauto {

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    NavigationStatusEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    NavigationStatusExitPoint();
}
